<#ibiztemplate>
TARGET=PSDELOGIC
</#ibiztemplate>
<#if item.isEnableBackend()>
<#assign startWF=false>
package ${pub.getPKGCodeName()}.core.${item.getPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.logic.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieContainer;

import ${pub.getPKGCodeName()}.core.${item.getPSDataEntity().getPSSystemModule().getCodeName()?lower_case}.service.logic.I${de.codeName}${item.codeName}Logic;
import ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().getCodeName()?lower_case}.domain.${de.getCodeName()};

/**
 * 关系型数据实体[${item.codeName}] 对象
 */
@Slf4j
@Service
public class ${de.codeName}${item.codeName}LogicImpl implements I${de.codeName}${item.codeName}Logic{

    @Autowired
    private KieContainer kieContainer;

    <#comment>注入处理逻辑中所用到的service对象</#comment>
    <#if item.getPSDELogicNodes?? && item.getPSDELogicNodes()??>
    <#list item.getPSDELogicNodes() as deLogicNode>
        <#if deLogicNode.getDstPSDataEntity?? && deLogicNode.getDstPSDataEntity()??>
            <#assign nodePSDataEntity=deLogicNode.getDstPSDataEntity()>
            <#if !P.exists("Autowired",nodePSDataEntity.getCodeName(),"service")>
    @Autowired
    private ${pub.getPKGCodeName()}.core.${nodePSDataEntity.getPSSystemModule().codeName?lower_case}.service.I${nodePSDataEntity.codeName}Service ${deLogicNode.getDstPSDataEntity().getCodeName()?lower_case}service;

    public ${pub.getPKGCodeName()}.core.${nodePSDataEntity.getPSSystemModule().codeName?lower_case}.service.I${nodePSDataEntity.codeName}Service get${deLogicNode.getDstPSDataEntity().getCodeName()?lower_case?cap_first}Service() {
        return this.${deLogicNode.getDstPSDataEntity().getCodeName()?lower_case}service;
    }

            </#if>
        </#if>
        <#comment>启动工作流</#comment>
        <#if deLogicNode.getLogicNodeType()=='STARTWF'>
            <#assign startWF=true>
            <#if !P.exists("delogic","wfclient")>
    @Autowired
    ${pub.getPKGCodeName()}.util.client.IBZWFFeignClient wfClient;
            </#if>
        </#if>
    </#list>
</#if>

    <#comment>注入当前实体的service对象，供自定义查询使用</#comment>
    @Autowired
    private ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().codeName?lower_case}.service.I${de.codeName}Service iBzSysDefaultService;

    public ${pub.getPKGCodeName()}.core.${de.getPSSystemModule().codeName?lower_case}.service.I${de.codeName}Service getIBzSysDefaultService() {
        return this.iBzSysDefaultService;
    }

    public void execute(${de.codeName} et){

          KieSession kieSession = null;
        try{
           kieSession=kieContainer.newKieSession();
<#comment>插入逻辑参数</#comment>
<#if item.getPSDELogicParams?? && item.getPSDELogicParams()??>
    <#assign logicName=(de.codeName+item.codeName)?lower_case>
    <#list item.getPSDELogicParams() as logicParam>
        <#assign paramObj=(logicName+logicParam.codeName)?lower_case>
        <#assign paramObjValue=(logicName+logicParam.codeName)?lower_case>
        <#if logicParam.isDefault()==true><#comment>默认变量</#comment>
            <#assign paramObjValue="et">
        <#elseif logicParam.getParamPSDataEntity?? && logicParam.getParamPSDataEntity()??>
            <#assign ParamPSDataEntity=logicParam.getParamPSDataEntity()>
           ${pub.getPKGCodeName()}.core.${ParamPSDataEntity.getPSSystemModule().codeName?lower_case}.domain.${ParamPSDataEntity.codeName}  ${(logicName+logicParam.codeName)?lower_case} =new ${pub.getPKGCodeName()}.core.${ParamPSDataEntity.getPSSystemModule().codeName?lower_case}.domain.${ParamPSDataEntity.codeName}();
        <#else>
           Map ${(logicName+logicParam.codeName)?lower_case} =new HashMap();
        </#if>
           kieSession.insert(${paramObjValue}); <#comment>将逻辑参数存储到fact中</#comment>
           kieSession.setGlobal("${paramObj}",${paramObjValue});<#comment>将逻辑参数存储到global中</#comment>
    </#list>
</#if>
<#comment>插入处理逻辑中所用到的service对象</#comment>
<#if item.getPSDELogicNodes?? && item.getPSDELogicNodes()??>
    <#list item.getPSDELogicNodes() as deLogicNode>
        <#if deLogicNode.getDstPSDataEntity?? && deLogicNode.getDstPSDataEntity()??>
            <#if !P.exists(item.codeName,"kieSessionGlobalService",deLogicNode.getDstPSDataEntity().getCodeName()?lower_case)>
           kieSession.setGlobal("${deLogicNode.getDstPSDataEntity().getCodeName()?lower_case}service",${deLogicNode.getDstPSDataEntity().getCodeName()?lower_case}service);<#comment>将逻辑中引用到的service存储到global中</#comment>
            </#if>
        </#if>
    </#list>
</#if>
<#comment>插入当前实体的defaultService对象，供自定义查询使用</#comment>
           kieSession.setGlobal("iBzSys${de.codeName?lower_case?cap_first}DefaultService",iBzSysDefaultService);<#comment>将逻辑中引用到的service存储到global中</#comment>
           kieSession.setGlobal("curuser", ${pub.getPKGCodeName()}.util.security.AuthenticationUser.getAuthenticationUser());
<#comment>插入wfclient</#comment>
        <#if startWF>
           kieSession.setGlobal("wfclient",wfClient);
        </#if>
           kieSession.startProcess("${pub.getPKGCodeName()}.core.${de.getPSSystemModule().codeName?lower_case}.service.logic.${de.codeName?lower_case}${item.getCodeName()?lower_case}");<#comment>执行所要执行的流程</#comment>

        }catch(Exception e){
            throw new RuntimeException("执行[${item.getName()}]处理逻辑发生异常"+e);
            <#--throw new BadRequestAlertException(""+e,"","");-->
        }finally {
            if(kieSession!=null)
            kieSession.destroy();
        }
    }

}
</#if>